;;; Loads up the MOP system and  the CHEF system
;;; and runs the CHEF demo.

;;; Setup the source-path

(define ICBR-source-dir "/l/www/hyplan/leake/cbr/code/microCHEF/")

;;; Parametrize would be nice here except that
;;; it requires read-access for the full path

(define p-load
  (lambda (path)
    (load (string-append ICBR-source-dir path))))

;;; Load the MOP system

(printf "~nLoading microMOPs ... ") (flush-output-port)
(p-load "mops/microMOPs.ss")
(p-load "mops/microMOPs.mops")
(printf "loaded~n")

;;; Micro Chef
(printf "Loading microCHEF ... ") (flush-output-port)
(p-load "chef/microCHEF.ss")
(p-load "chef/microCHEF.mops")
(printf "loaded~n")

(printf "~nType (chef-demo) to run the demo~n")




