;; some tools to simplify the code
;; the other option was to write a bunch of macros
;; to simulate LISP in scheme

;; would call it collect but that's used to invoke the garbage collector
;; note that the results of the gather are in reverse order...
(define gather
  (lambda (ls fn update)
    (let loop ((ls ls) (result '()))
      (if (null? ls)
	  result
	  (loop (cdr ls) (update (fn (car ls)) result))))))

;; this seems to work more like the LISP thing
(define reduce
  (lambda (fn ls init-val)
    (let loop ((ls ls) (acc init-val))
      (if (null? ls)
	  acc
	  (loop (cdr ls) (fn acc (car ls)))))))

;; also seem to need subst that uses equal?

(define subst
  (lambda (new old ls)
    (let loop ((ls ls))
      (cond
	[(null? ls) '()]
	[(equal? old (car ls))
	 (cons new (loop (cdr ls)))]
	[else (cons (car ls) (loop (cdr ls)))]))))
  
(provide "utils")
