;; oscar waddell: draft of hash table thing

;; table-init
;;
;;   given table-size and a continuation creates table of given size and
;;   functions for manipulating the table, applies k to lookup insert and
;;   delete functions, k can then do some set!s to export them or just use
;;   them in lexical scope.  Shares code among all tables created in case
;;   we want to create several tables.
;;
;;   presently limited to hashing symbols, should parameterize it to take
;;   optional hash function.
;;
;;   provides:
;;     (lookup key)
;;     (insert key value)
;;     (delete key)

(define table-init
  (let
    ((make-hash
       (lambda (table-size)
	 (lambda (symbol)
	   ;; should have check here to ensure symbol is a symbol
	   (let ((string (symbol->string symbol)))
	     (let loop ((val (fxsll (char->integer (string-ref string 0)) 7))
			(i (fx- (string-length string) 1)))
	       (if (fxzero? i)
		   (fxmodulo val table-size)
		   (loop (fxlogxor val (char->integer (string-ref string i)))
			 (fx- i 1))))))))
     (make-lookup
       (lambda (table hash)
	 (lambda (key)
	   (let ((result (flassq key (vector-ref table (hash key)))))
	     (if result (cadr result) #f)))))
     (make-insert
       (lambda (table hash)
	 (lambda (key value)
	   (let* ((index (hash key))
		  (bucket (vector-ref table (hash key)))
		  (result (flassq key bucket)))
	     (if result
		 (set-car! (cdr bucket) value)
		 (vector-set! table index (cons key (cons value bucket))))))))
     (make-delete
       (lambda (table hash)
	 (lambda (key)
	   (let ((index (hash key)))
	     (let loop ((bucket (vector-ref table (hash key))) (back #f))
	       (unless (null? bucket)
		 (if (eq? key (car bucket))
		     (if back
			 (set-cdr! back (cddr bucket))
			 (vector-set! table index (cddr bucket)))
		     (loop (cddr bucket) (cdr bucket))))))))))
    (lambda (table-size k)
      ;; let make-vector give warning about bogus table-sizes
      (let ((table (make-vector table-size '()))
	    (hash  (make-hash table-size)))
	(set! test (lambda () (printf "version 2:~n") table))
	(k (make-lookup table hash)
	   (make-insert table hash)
	   (make-delete table hash))))))

;; search for key in the flat assq list input-ls
;; if found return the rest of the list containing key
;;
;; no more efficient than assoc lists of the form
;; ((key . value) ...) in space or time, but this may
;; be needed to simulate some of the common lisp behavior
;; of setf (see frames.ss) of micro-swale port

(define flassq
  (lambda (key input-ls)
    (let loop ((ls input-ls))
      (cond
	((null? ls) #f)
	((eq? key (car ls)) ls)
	(else
	  (let ((tmp (cdr ls)))
	    (if (null? tmp)
		(error 'flassq "improperly formed flat assq list ~a"
		  input-ls)
		(loop (cdr tmp)))))))))
