;; quick draft of a queue structure
;; ideally the queue-head and queue-tail stuff and the setters
;; would be hidden from the user of this package...

;; see The Scheme Programming Language p. 183 for more on define-structure

(define-structure (queue) ((head (cons #f #f)) (tail head)))

(define queue-empty?
  (lambda (q)
    (if (not (queue? q))
	(error 'queue-empty "applied to non-queue")
	(eq? (queue-head q) (queue-tail q)))))

(define enqueue
  (lambda (item q)
    (if (not (queue? q))
	(error 'enqueue "attempt to enqueue into non-queue")
	(let ((next (list item)))
	  (set-cdr! (queue-tail q) next)
	  (set-queue-tail! q next)))))

(define dequeue
  (lambda (q)
    (if (not (queue? q))
	(error 'dequeue "attempt to dequeue from non-queue")
	(if (queue-empty? q)
	    (error 'dequeue "empty queue")
	    (let ((next (cdr (queue-head q))))
	      (set-queue-head! q next)
	      (car next))))))

(define iterate-queue-until
  (lambda (fn q)
    (if (not (queue? q))
	(error 'iterate-queue-until "applied to non-queue")
	(let loop ()
	  (unless (or (eq? (queue-head q) (queue-tail q)) ; use faster empty
		      (fn (dequeue q)))                   ; test since q's ok
	    (loop))))))

(provide "queue")