;; quick and literal translation of INDEX.LISP

(define-structure (index) ((entries '())))
(define-structure (index-entry labels items))

(define clear-index
  (lambda (index)
    (set-index-entries! index '())))

(define index-fetch
  (lambda (cues index)
    (let loop ((entries (index-entries index)) (result '()))
      (if (null? entries)
	  result
	  (loop (cdr entries)
		(let* ((entry (car entries))
		       (labels (index-entry-labels entry)))
		  (if (subset? labels cues abst?)
		      (append (index-entry-items entry) result)
		      result)))))))

;; looks like we just add item to the list of things we retrieve if any
;; and create such a list otherwise

(define index-store
  (lambda (labels item index)
    (unless (null? labels)
      (let ((entry (find-index-entry labels index)))
	(if entry
	    (set-index-entry-items! entry
	      (cons item (index-entry-items entry)))
	    (set-index-entries! index
	      (cons (make-index-entry labels (list item))
		    (index-entries index))))
	(void)))))

;; remq will get redundant items  (assuming everything is eq?)

(define index-remove
  (lambda (labels item index)
    (let ((entry (find-index-entry labels index)))
      (when entry
	(let ((items (remq item (index-entry-items entry))))
	  (if (null? items)
	      (set-index-entries! index
		(remq entry (index-entries index)))
	      (set-index-entry-items! entry items)))))))


;; could use my set-hash stuff instead

(define find-index-entry
  (lambda (labels index)
    (find labels (index-entries index)
      set-equal?
      index-entry-labels)))

(define set-equal?
  (lambda (x y)
    (and (subset? x y eq?) (subset? y x eq?))))

(define find
  (lambda (quarry entries pred? extract)
    (let loop ((entries entries))
      (if (null? entries)
	  #f
	  (let ((first (car entries)))
	    (if (pred? quarry (extract first))
		first
		(loop (cdr entries))))))))

(define subset?
  (let ((id (lambda (x) x)))
    (lambda (x y pred?)
      (let loop ((x x))
	(if (null? x)
	    #t
	    (and (find (car x) y pred? id) (loop (cdr x))))))))
