;;; ----------------------------------------------------------------------
;;; Micro APPLIER
;;; ----------------------------------------------------------------------
;;; Programmer: Alex Kass, Chris Riesbeck


(require "mops")


;;; Apply an XP to a story
;;; ----------------------------------------------------------------

(define apply-xp
  (lambda (xp story)

    (printf "Applying ~s.~n" xp)

    (summarize-results (new-explanation `((story . ,story) (xp . ,xp)))
      "... didn't work."
      (lambda (expl)
	(printf "... generated ~s.~n" expl)))))



;;; Explanation maker
;;; ----------------------------------------------------------------

(define new-explanation
  (lambda (args)
    (add-instance (gentemp "m-expl") 'm-explanation args)))


;; (could use gensym if I looked up the way of specifying prefix)

(define gentemp
  (let ([count 0])
    (lambda (str)
      (set! count (+ count 1))
      (string->symbol (string-append str (number->string count))))))

;;; End of module
;;; ----------------------------------------------------------------

(provide "applier")

