;;; ----------------------------------------------------------------
;;; Swale Demo
;;; ----------------------------------------------------------------
;;; Programmer: Chris Riesbeck


(require "explainer")


;;; Run the Swale story with fresh memory.
;;; ----------------------------------------------------------------------

(defun explain-swale ()
  (reset-swale-memory)
  (explain 'm-swale-story))


(defun reset-swale-memory ()
  (clear-mop-memory)
  (load-swale-memory))

(defun load-swale-memory ()
  (unprovide "swale-mem")
  (require "swale-mem"))

(defun unprovide (module)
  (setq *modules*
        (remove module *modules* :test #'string-equal)))



;;; End of module
;;; ----------------------------------------------------------------


(provide "swale")

