;;; ----------------------------------------------------------------------
;;; Micro APPLIER
;;; ----------------------------------------------------------------------
;;; Programmer: Alex Kass, Chris Riesbeck


(require "mops")


;;; Apply an XP to a story
;;; ----------------------------------------------------------------

(defun apply-xp (xp story)

  (mainline "Applying ~S." xp)

  (summarize-results (new-explanation :story story :xp xp)
     "... didn't work."
     "... generated ~S."))



;;; Explanation maker
;;; ----------------------------------------------------------------

(defun new-explanation (&rest args)
  (add-instance (gentemp "M-EXPL")
                'm-explanation
                args))


;;; End of module
;;; ----------------------------------------------------------------

(provide "applier")

